#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXN 200005

typedef long long ll;

/* Fenwick tree */
typedef struct {
    int n;
    ll *t;
} BIT;

void bit_init(BIT *b, int n) {
    b->n = n;
    b->t = calloc(n + 1, sizeof(ll));
}

void bit_add(BIT *b, int i, ll v) {
    for (; i <= b->n; i += i & -i)
        b->t[i] += v;
}

ll bit_sum(BIT *b, int i) {
    ll s = 0;
    for (; i > 0; i -= i & -i)
        s += b->t[i];
    return s;
}

/* Global */
int N, Q;
int a[MAXN];
int last[MAXN], freq[MAXN];
ll prefSum[MAXN];

BIT bitCnt, bitSum;

int main() {
    scanf("%d %d", &N, &Q);

    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        last[a[i]] = i;
    }

    bit_init(&bitCnt, N);
    bit_init(&bitSum, N);

    for (int i = 1; i <= N; i++) {
        freq[a[i]]++;
        prefSum[i] = prefSum[i - 1] + a[i];
    }

    while (Q--) {
        int t;
        scanf("%d", &t);

        if (t == 1) {
            int k;
            scanf("%d", &k);

            if (k == N) {
                printf("%lld\n", prefSum[N]);
                continue;
            }

            int rem = N - k;
            ll total = prefSum[k];

            ll lo = 1, hi = N, pos = 0;
            while (lo <= hi) {
                ll mid = (lo + hi) >> 1;
                if (bitCnt.t[mid] >= rem) {
                    pos = mid;
                    hi = mid - 1;
                } else lo = mid + 1;
            }

            ll taken = bitSum.t[pos];
            printf("%lld\n", total - taken);
        } else {
            int x, y;
            scanf("%d %d", &x, &y);

            int old = a[x];
            a[x] = y;
        }
    }

    return 0;
}